import pandas as pd, numpy as np, matplotlib.pyplot as plt
df = pd.read_csv("outputs/lensing_plateau.csv")
def parse_mid(s):
    s = str(s).replace('–','-').replace('to','-')
    num = ''.join(ch if ch.isdigit() or ch=='.' or ch=='-' else ' ' for ch in s)
    parts = [p for p in num.split() if p]
    vals=[]
    for p in parts:
        try: vals.append(float(p))
        except: pass
    if len(vals)>=2: return 0.5*(vals[0]+vals[1])
    if len(vals)==1: return vals[0]
    return np.nan
df["R_G_mean_kpc"] = df["R_G_bin"].apply(parse_mid)
plt.figure()
for mstar in sorted(df["Mstar_bin"].dropna().unique()):
    d = df[(df["Mstar_bin"]==mstar) & (df["claimable"]==True)]
    if d.empty: continue
    plt.scatter(d["R_G_mean_kpc"], d["A_theta"], s=20, alpha=0.8, label=str(mstar))
plt.xlabel("R_G [kpc] (bin midpoint)")
plt.ylabel("A_theta (median of gamma_t * b)")
plt.title("T3: amplitude vs size (per Mstar bin)")
plt.savefig("figures/amplitude_vs_size.png", dpi=160, bbox_inches="tight")
print("Saved figures/amplitude_vs_size.png")
